// Header File
// Created 3/5/2005; 9:55:07 AM


#ifndef _GrayUtils
#define _GrayUtils

#include "BasicTypes.h"


extern unsigned char* PLANE_CurrentPlane0;
extern unsigned char* PLANE_CurrentPlane1;
extern unsigned char* PLANE_PreviousPlane0;
extern unsigned char* PLANE_PreviousPlane1;

extern unsigned char* PLANE_Plane0;
extern unsigned char* PLANE_Plane1;
extern unsigned char* PLANE_Plane2;
extern unsigned char* PLANE_Plane3;

extern void* DoubleBuffer;
extern INT_HANDLER saveInt1;

StatusType GrayScaleOn(void);
StatusType GrayScaleOff(void);
void SwapPlaneBuffers(void);
void GrayFillScreen(int2 color);
uint1* SpriteInvert8(uint2 height, uint1* sprite);


extern void GraySetScreenColor_R(
    register short color asm("%d0"),
    register void* lightplane asm("%a0"),
    register void* darkplane asm("%a1"))
    __attribute__((__stkparm__));

/*extern void GraySingleSprite8_COLOR_R(
		register short x asm("%d0"),
		register short y asm("%d1"),
		register short h asm("%d2"),
		unsigned char *sprt0, // a2
		unsigned short color, // d4
		register void *dest0 asm("%a0"),
		register void *dest1 asm("%a1"))
		 __attribute__((__stkparm__));*/

extern void GrayClipSingleSprite8_COLOR_R(
    register short x asm("%d0"),
    register short y asm("%d1"),
    register short h asm("%d2"),
    unsigned char *sprt,    // a2
    unsigned short color,   // d4
    register void *dest0 asm("%a0"),
    register void *dest1 asm("%a1"))
    __attribute__((__stkparm__));

extern void GrayClipSingleSprite16_COLOR_R(
    register short x asm("%d0"),
    register short y asm("%d1"),
    register short h asm("%d2"),
    unsigned short *sprt,   // a2
    unsigned short color,   // d4
    register void *dest0 asm("%a0"),
    register void *dest1 asm("%a1"))
    __attribute__((__stkparm__));

#endif // _GrayUtils